<?php
if ( ! function_exists( 'artabr_load' ) ) {
	
	function artabr_load() {
		include( get_stylesheet_directory() . '/inc/theme-custom-post-types.php' );
		include( get_stylesheet_directory() . '/inc/custom-metabox-gallery.php' );
		
	}
}
add_action( 'after_setup_theme', 'artabr_load' );

function elegant_enqueue_css() {
	wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_script( 'script-modal', get_stylesheet_directory_uri() . '/js/custom_modal.js', array( 'jquery' ),'dct_1.0', true );
	
}
add_action( 'wp_enqueue_scripts', 'elegant_enqueue_css' );

function artabr_fg_enqueue_stuff() {
	
	wp_enqueue_media();
	wp_enqueue_script( 'fg-script-admin', get_stylesheet_directory_uri() . '/js/custom-metabox-gallery.js' );
	wp_localize_script( 'fg-script-admin', 'myAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));
	
	wp_enqueue_style( 'fg-style-admin', get_stylesheet_directory_uri() . '/css/custom-gallery.css' );
	//$show_sidebar = apply_filters( 'fg_show_sidebar', false );
	
}
add_action( 'admin_enqueue_scripts', 'artabr_fg_enqueue_stuff' );

include('editor/footer-editor.php');

include('editor/login-editor.php');

include ('inc/cistom-shortcodes.php');

// ====================== Footer Editor ======================

function art_topbar_setting($wp_customize) {
	$wp_customize->add_setting( 'et_divi[phone_number2]', array(
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'		=> 'postMessage',
		'sanitize_callback' => 'et_sanitize_html_input_text',
	) );
	$wp_customize->add_control( 'et_divi[phone_number2]', array(
		'label'		=> esc_html__( 'Второй номер', 'Divi' ),
		'section'	=> 'et_divi_header_information',
		'type'      => 'text',
	) );
	$wp_customize->add_setting( 'et_divi[feedback_call]', array(
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'		=> 'postMessage',
		'sanitize_callback' => 'et_sanitize_html_input_text',
	) );
	$wp_customize->add_control( 'et_divi[feedback_call]', array(
		'label'		=> esc_html__( 'Шорткод обратного звонка', 'Divi' ),
		'section'	=> 'et_divi_header_information',
		'type'      => 'text',
	) );
	
	$wp_customize->add_setting( 'et_divi[phone_primary_header]', array(
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'		=> 'postMessage',
		'sanitize_callback' => 'et_sanitize_html_input_text',
	) );
	$wp_customize->add_control( 'et_divi[phone_primary_header]', array(
		'label'		=> esc_html__( 'Телефон в основном меню', 'Divi' ),
		'section'	=> 'et_divi_header_layout',
		'type'      => 'text',
	) );
	$wp_customize->add_setting( 'et_divi[adress_primary_header]', array(
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'		=> 'postMessage',
		'sanitize_callback' => 'et_sanitize_html_input_text',
	) );
	$wp_customize->add_control( 'et_divi[adress_primary_header]', array(
		'label'		=> esc_html__( 'Адрес в основном меню', 'Divi' ),
		'section'	=> 'et_divi_header_layout',
		'type'      => 'text',
	) );
	$wp_customize->add_setting( 'et_divi[feedback_call_primary_header]', array(
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'		=> 'postMessage',
		'sanitize_callback' => 'et_sanitize_html_input_text',
	) );
	$wp_customize->add_control( 'et_divi[feedback_call_primary_header]', array(
		'label'		=> esc_html__( 'Шорткод обратного звонка для основного меню', 'Divi' ),
		'section'	=> 'et_divi_header_layout',
		'type'      => 'text',
	) );
	$wp_customize->add_setting( 'et_divi[description_primary_header]', array(
		'type'			=> 'option',
		'capability'	=> 'edit_theme_options',
		'transport'		=> 'postMessage',
		'sanitize_callback' => 'wp_validate_boolean',
	) );
	
	$wp_customize->add_control( 'et_divi[description_primary_header]', array(
		'label'		=> esc_html__( 'Скрыть описание сайта', 'Divi' ),
		'section'	=> 'et_divi_header_layout',
		'type'      => 'radio',
		'choices'    => array(
			'yes'     => esc_html__( 'Да', 'Divi' ),
			'no'      => esc_html__( 'Нет', 'Divi' ),
		),
	) );
	
}

add_action('customize_register', 'art_topbar_setting',11,2);
if ( ! function_exists( 'et_divi_header_style_choices' ) ) :
	/**
	 * Returns list of header styles used by Divi
	 * @return array
	 */
	function et_divi_header_style_choices() {
		return apply_filters( 'et_divi_header_style_choices', array(
			'left'       => esc_html__( 'Default', 'Divi' ),
			'centered'   => esc_html__( 'Centered', 'Divi' ),
			'split'	     => esc_html__( 'Centered Inline Logo', 'Divi' ),
			'slide'      => esc_html__( 'Slide In', 'Divi' ),
			'fullscreen' => esc_html__( 'Fullscreen', 'Divi' ),
			'logo_desc' => esc_html__( 'Logo Discriptions', 'Divi' ),
		) );
	}
endif;

add_filter( 'body_class', 'artabr_et_add_logo_disc_body_class' );
function artabr_et_add_logo_disc_body_class( $classes ){
	if ( 'logo_desc' === et_get_option( 'header_style', 'left' )) {
		$classes[] = 'et_header_style_centered';
		return $classes;
	} else {
		$classes[] = '';
		return $classes;
	}
}

function artabr_et_divi_add_customizer_css(){
	$header_style = et_get_option( 'header_style', 'left' );
	$logo_height = absint( et_get_option( 'logo_height', '54' ) );
	$menu_height = absint( et_get_option( 'menu_height', '66' ) );
	?>
	<style id="artabr-theme-customizer-css">
		
		<?php if ( 64 !== $logo_height && 'logo_desc' === $header_style ) { ?>
		.et_header_style_centered #logo { max-height: <?php echo esc_html( $logo_height . '%' ); ?>;margin-right: 4%;vertical-align: inherit;}
		.et_pb_svg_logo.et_header_style_centered #logo { height: <?php echo esc_html( $logo_height . '%' ); ?>; }
		.et_header_style_centered #main-header .logo_container { height: <?php echo esc_html( $menu_height ); ?>px; }
		.desc-site, .contact-site{display: inline-block;vertical-align: top;margin-right: 3%;margin: 1% 0;}
		.contact-site{margin-right: 0;}
		.desc-site{    margin: 3% 3% 0 0;font-size: 20px;font-weight: bold;}
		<?php } ?>
	</style>
	
	<?php
}
add_action( 'wp_head', 'artabr_et_divi_add_customizer_css' );




add_filter( 'style_loader_src', 'remove_cssjs_ver', 10, 2 );
add_filter( 'script_loader_src', 'remove_cssjs_ver', 10, 2 );
function remove_cssjs_ver( $src ) {
	if( strpos( $src, '?ver=' ) )
		$src = remove_query_arg( 'ver', $src );
	return $src;
}
