<?php
add_action( 'add_meta_boxes', 'artabr_fg_register_metabox' );
function artabr_fg_register_metabox() {

  $post_types = apply_filters( 'fg_post_types', array( 'gallery') );
  $context  = apply_filters( 'fg_context', 'normal' );
  $priority = apply_filters( 'fg_priority', 'high' );

  foreach ( $post_types as $post_type ) {

    add_meta_box( 'featuredgallerydiv', __( 'Featured Gallery', 'featured-gallery' ), 'artabr_fg_display_metabox', $post_type, $context, $priority );

  }

}

function artabr_fg_display_metabox() {

  global $post;

  // Get the Information data if its already been entered
  $galleryHTML = ''; $oldfix = '';
  if ( get_bloginfo( 'version' ) >= 3.8 ) {
    $button = '<button></button>';
  } else {
    $button = '<button class="media-modal-icon"></button>';
    $oldfix = ' premp6';
  }
  $selectText    = __( 'Select Images', 'featured-gallery' );
  $visible       = ''; //SHOULD WE SHOW THE REMOVE ALL BUTTON? THIS WILL BE APPLIED AS A CLASS, AND IS BLANK BY DEFAULT.
  $galleryArray  = artabr_get_post_gallery_ids( $post->ID );
  $galleryString = artabr_get_post_gallery_ids( $post->ID, 'string' );
  if ( ! empty( $galleryString ) ) {
    foreach ( $galleryArray as &$id ) {
      $galleryHTML .= '<li>'.$button.'<img id="'.$id.'" src="'.wp_get_attachment_url( $id ).'"></li> ';
    }
    $selectText = __( 'Edit Selection', 'featured-gallery' );
    $visible    = " visible";
  } 
  update_post_meta( $post->ID, 'fg_temp_metadata', $galleryString ); // Overwrite the temporary featured gallery data with the permanent data. This is a precaution in case someone clicks Preview Changes, then exits withing saving. ?>

  <input type="hidden" name="fg_temp_noncedata" id="fg_temp_noncedata" value="<?php echo wp_create_nonce( 'fg_temp_noncevalue' ); ?>" />

  <input type="hidden" name="fg_perm_noncedata" id="fg_perm_noncedata" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />

  <input type="hidden" name="fg_perm_metadata" id="fg_perm_metadata" value="<?php echo $galleryString; ?>" data-post_id="<?php echo $post->ID; ?>" />

  <button class="button" id="fg_select"><?php echo $selectText; ?></button>

  <button class="button<?php echo $visible.$oldfix; ?>" id="fg_removeall"><?php _e( 'Remove All', 'featured-gallery' ); ?></button>

  <ul><?php echo $galleryHTML; ?></ul>

  <div style="clear:both;"></div><?php

}

add_action( 'save_post', 'artabr_fg_save_perm_metadata', 1, 2 );
function artabr_fg_save_perm_metadata( $post_id, $post ) {

  //Only run the call when updating a Featured Gallery.
  if ( empty( $_POST['fg_perm_noncedata'] ) ) {
    return;
  }
  // Noncename
  if ( ! wp_verify_nonce( $_POST['fg_perm_noncedata'], plugin_basename( __FILE__ ) ) ) {
    return;
  }
  // Verification of User
  if ( ! current_user_can( 'edit_post', $post->ID ) ) {
    return;
  }
  // OK, we're authenticated: we need to find and save the data
  $events_meta['fg_perm_metadata'] = $_POST['fg_perm_metadata'];
  // Add values of $events_meta as custom fields
  foreach ( $events_meta as $key => $value ) {
    if ( $post->post_type == 'revision' ) {
      return;
    }
    $value = implode( ',', (array)$value );
    if ( get_post_meta( $post->ID, $key, FALSE ) ) {
      update_post_meta( $post->ID, $key, $value );
    } else {
      add_post_meta( $post->ID, $key, $value );
    }
    if ( ! $value ) {
      delete_post_meta( $post->ID, $key );
    }
  }

}
add_action( 'wp_ajax_fg_update_temp', 'fg_update_temp_callback' );
function fg_update_temp_callback() {

  if ( ! wp_verify_nonce( $_REQUEST['fg_temp_noncedata'], "fg_temp_noncevalue" ) ) {
    exit( "You shouldn't have gotten here, something is going wrong." );
  }
  if ( ! current_user_can( 'edit_post', $_REQUEST['fg_post_id'] ) ) {
    exit( "You don't appear to be logged in, something is going wrong here." );
  }

  $newValue = $_REQUEST['fg_temp_metadata'];
  $oldValue = get_post_meta( $_REQUEST['fg_post_id'], 'fg_temp_metadata', 1 );
  $response = "success";

  if ( $newValue != $oldValue ) {

    $success = update_post_meta( $_REQUEST['fg_post_id'], 'fg_temp_metadata', $newValue );

    if ( $success == false ) {
      $response = "error";
    }

  }

  echo json_encode( $response );

 wp_die();

}

function artabr_get_post_gallery_ids($id,$max_images=-1,$method="array") {
  if (is_preview($id)) {
    $galleryString = get_post_meta( $id, 'fg_temp_metadata', 1);
  } else {
    $galleryString = get_post_meta( $id, 'fg_perm_metadata', 1);
  }
  if ($method == "string" || $max_images == "string") {
    return $galleryString;
  } else {
    if ( ! $galleryString ) {
      return array();
    } else {
      if ($max_images == -1) {
        return explode(',', $galleryString);
      } else {
        return array_slice(explode(',', $galleryString), 0, $max_images);
      }
    }
  }
}